/*
 * 쐬: 2005/05/13
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ext.s2jdbc.copy;

import java.sql.Types;
import java.util.Iterator;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.ClipboardUtils;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TableElement;
import zigen.plugin.db.ext.s2jdbc.Activator;
import zigen.plugin.db.ext.s2jdbc.util.PropertyNameUtil;
import zigen.plugin.db.preference.PreferencePage;
import zigen.plugin.db.ui.internal.ITable;


public class CopyCreateInstanceCodeAction extends AbstractCopyAction {

	protected boolean underLineCut = false;

	protected String nullSymbol = null;

	protected String getProperty(TableColumn tCol) {
		if (!underLineCut) {
			return tCol.getColumnName().toLowerCase();
		} else {
			return PropertyNameUtil.getPropertyName(tCol.getColumnName());
		}
	}

	public void run() {

		try {
			IPreferenceStore store = DbPlugin.getDefault().getPreferenceStore();
			// underLineCut = store.getBoolean(GeneratePreferencePage.P_UNDER_LINE_CUT);
			underLineCut = true; // S2̏ꍇ_͏ȗ
			nullSymbol = store.getString(PreferencePage.P_NULL_SYMBOL);

			StringBuffer sb = new StringBuffer();
			Clipboard clipboard = ClipboardUtils.getInstance();
			TextTransfer text_transfer = TextTransfer.getInstance();
			ITable table = editor.getTableNode();

			Iterator iter = selection.iterator();
			int index = 0;
			while (iter.hasNext()) {
				Object obj = iter.next();
				if (obj instanceof TableElement) {
					TableElement elem = (TableElement) obj;

					String className = getClassName(table);
					String name = getFieldName(table, index);

					// CX^X
					sb.append(className).append(" ").append(name).append(" = new " + className + "();");
					sb.append(LINE_SEP);


					TableColumn[] columns = elem.getColumns();
					// Jw肷悤ɏC
					for (int i = 0; i < columns.length; i++) {
						TableColumn col = columns[i];
						Object value = elem.getItem(col);
						sb.append(name).append(".").append(getProperty(col)).append(" = ").append(createValue(col, value)).append(";");
						sb.append(LINE_SEP);

					}

					index++;

				}
			}
			clipboard.setContents(new Object[] {sb.toString()}, new Transfer[] {text_transfer});

		} catch (Exception e) {
			Activator.getDefault().showErrorDialog(e);
		}

	}

	protected String getClassName(ITable table) {
		if (table != null) {
			return PropertyNameUtil.getEntityName(table.getName());
		} else {
			return "ValueObject";
		}
	}

	protected String getFieldName(ITable table, int index) {
		String fieldName = null;
		if (table != null) {
			fieldName = "entity";
		} else {
			fieldName = "vo";
		}

		if (index != 0) {
			return fieldName + (++index);
		}

		return fieldName;
	}


	protected String createValue(TableColumn col, Object value) {

		int type = col.getDataType();
		String str = String.valueOf(value);

		if (str.equals(nullSymbol)) {
			return "null";
		}

		StringBuffer sb = new StringBuffer();
		String obj = "";
		switch (type) {
			case Types.CHAR:
			case Types.VARCHAR:
			case Types.LONGVARCHAR: // -1
				sb.append("\"");
// f[^Ƀ_uNH[g܂܂Ăꍇl
				str = str.replaceAll("\"", "\\\\\""); // "΁A""ɒu

				sb.append(str);
				sb.append("\"");
				obj = sb.toString();
				break;

			case Types.TINYINT:
			case Types.INTEGER: // ʓIɂint
			case Types.SMALLINT: // ʓIɂshort
			case Types.BIGINT: // ʓIɂlong
			case Types.REAL: // ʓIɂfloat
			case Types.FLOAT: // ʓIɂdouble
			case Types.DOUBLE: // ʓIɂdouble
			case Types.NUMERIC: // ʓIɂBigDecimal
			case Types.DECIMAL:// ʓIɂBigDecimal
				obj = "new java.math.BigDecimal(" + str + ")";
				break;


			case Types.DATE:
				// obj = "java.sql.Date.valueOf(\""+ String.valueOf(value) +"\")";
				obj = "new java.sql.Date(new java.text.SimpleDateFormat(\"yyyy-MM-dd HH:mm:ss\").parse(\"" + str + "\").getTime())";


				break;
			case Types.TIMESTAMP:
				// obj = "new java.sql.Date(Calendar.getInstance().getTime().getTime())";
				// obj = "java.sql.Timestamp.valueOf(\""+ String.valueOf(value) +"\")";
				obj = "new java.sql.Timestamp(new java.text.SimpleDateFormat(\"yyyy-MM-dd HH:mm:ss.SSS\").parse(\"" + str + "\").getTime())";

				break;

			// case Types.BINARY: // -2
			// case Types.VARBINARY: // -3
			// case Types.LONGVARBINARY: // -4
			// obj = getBinary(rs, icol); // oCi[\
			// break;
			//
			// case Types.CLOB:
			// obj = getCLOB(rs, icol);
			// break;
			// case Types.BLOB:
			// obj = getBLOB(rs, icol);
			// break;
			//
			// case Types.OTHER:
			// obj = getOTHER(rs, icol);
			// break;

			default:
				obj = "<<sȌ^(" + type + ")>>";
				break;
		}
		return obj;
	}
}
